/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings;

import com.minecolonies.api.blocks.AbstractBlockHut;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.IBuildingContainer;
import com.minecolonies.api.colony.requestsystem.requestable.deliveryman.AbstractDeliverymanRequestable;
import com.minecolonies.api.tileentities.AbstractTileEntityColonyBuilding;
import com.minecolonies.api.tileentities.TileEntityColonyBuilding;
import com.minecolonies.api.tileentities.TileEntityRack;
import com.minecolonies.coremod.blocks.BlockMinecoloniesRack;
import com.minecolonies.coremod.colony.buildings.AbstractSchematicProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractBuildingContainer
extends AbstractSchematicProvider
implements IBuildingContainer {
    protected final Set<BlockPos> containerList = new HashSet<BlockPos>();
    protected final Map<Predicate<ItemStack>, Tuple<Integer, Boolean>> keepX = new HashMap<Predicate<ItemStack>, Tuple<Integer, Boolean>>();
    protected AbstractTileEntityColonyBuilding tileEntity;
    private int unscaledPickUpPriority = 1;

    public AbstractBuildingContainer(BlockPos pos, IColony colony) {
        super(pos, colony);
    }

    @Override
    public void deserializeNBT(CompoundTag compound) {
        super.deserializeNBT(compound);
        ListTag containerTagList = compound.m_128437_("Containers", 10);
        for (int i = 0; i < containerTagList.size(); ++i) {
            CompoundTag containerCompound = containerTagList.m_128728_(i);
            this.containerList.add(NbtUtils.m_129239_((CompoundTag)containerCompound));
        }
        if (compound.m_128431_().contains("prio")) {
            this.unscaledPickUpPriority = compound.m_128451_("prio");
        }
        if (compound.m_128431_().contains("prioState") && compound.m_128451_("prioState") == 0) {
            this.unscaledPickUpPriority = 0;
        }
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compound = super.serializeNBT();
        @NotNull ListTag containerTagList = new ListTag();
        for (BlockPos pos : this.containerList) {
            containerTagList.add((Object)NbtUtils.m_129224_((BlockPos)pos));
        }
        compound.m_128365_("Containers", (Tag)containerTagList);
        compound.m_128405_("prio", this.unscaledPickUpPriority);
        return compound;
    }

    @Override
    public int getPickUpPriority() {
        return this.unscaledPickUpPriority;
    }

    @Override
    public void alterPickUpPriority(int value) {
        this.unscaledPickUpPriority = Mth.m_14045_((int)(this.unscaledPickUpPriority + value), (int)0, (int)AbstractDeliverymanRequestable.getMaxBuildingPriority(false));
    }

    @Override
    public void addContainerPosition(@NotNull BlockPos pos) {
        this.containerList.add(pos);
    }

    @Override
    public void removeContainerPosition(BlockPos pos) {
        this.containerList.remove(pos);
    }

    @Override
    public List<BlockPos> getContainers() {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>(this.containerList);
        list.add(this.getPosition());
        return list;
    }

    @Override
    public void registerBlockPosition(@NotNull BlockState blockState, @NotNull BlockPos pos, @NotNull Level world) {
        this.registerBlockPosition(blockState.m_60734_(), pos, world);
    }

    @Override
    public void registerBlockPosition(@NotNull Block block, @NotNull BlockPos pos, @NotNull Level world) {
        if (block instanceof AbstractBlockHut) {
            BlockEntity entity = world.m_7702_(pos);
            if (entity instanceof TileEntityColonyBuilding) {
                ((TileEntityColonyBuilding)entity).setStyle(this.getStyle());
                ((TileEntityColonyBuilding)entity).setMirror(this.isMirrored());
                IBuilding building = this.colony.getBuildingManager().getBuilding(pos);
                if (building != null) {
                    building.setStyle(this.getStyle());
                    building.setParent(this.getID());
                    this.addChild(pos);
                }
            }
        } else if (block instanceof BlockMinecoloniesRack) {
            this.addContainerPosition(pos);
            BlockEntity entity = world.m_7702_(pos);
            if (entity instanceof TileEntityRack) {
                ((TileEntityRack)entity).setBuildingPos(this.getID());
            }
        }
    }

    @Nullable
    protected BlockPos getFirstLocationFromTag(@NotNull String tagName) {
        List<BlockPos> locations = this.getLocationsFromTag(tagName);
        return locations.isEmpty() ? null : locations.get(0);
    }

    @NotNull
    protected List<BlockPos> getLocationsFromTag(@NotNull String tagName) {
        if (this.tileEntity != null) {
            return new ArrayList<BlockPos>(this.tileEntity.getWorldTagNamePosMap().getOrDefault(tagName, Collections.emptySet()));
        }
        return Collections.emptyList();
    }

    @Override
    public void setTileEntity(AbstractTileEntityColonyBuilding te) {
        this.tileEntity = te;
        if (te != null && te.isOutdated()) {
            this.safeUpdateTEDataFromSchematic();
        }
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.getTileEntity() != null) {
            return this.tileEntity.getCapability(cap, side);
        }
        return LazyOptional.empty();
    }
}

